unit Form_timeSignal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, Grids, BaseGrid, AdvGrid, AdvCGrid, MMObj,
  MMBmpLst, MMBmpBtn, ExtCtrls, MMPanel, MMFill, MMDSPObj, MMWavOut,
  MMAudio, MMHook, MMDesign, MMPitch,MMMPEG, MMHTimer;

type
  Ttimesignal = class(TForm)
    sf1: TbsBusinessSkinForm;
    MMPanelFill5: TMMPanelFill;
    addplaylist: TMMBitmapButton;
    MMBitmapButton3: TMMBitmapButton;
    playlistgrid: TAdvColumnGrid;
    MMPanelFill1: TMMPanelFill;
    play: TMMBitmapButton;
    MMBitmapButton1: TMMBitmapButton;
    MMDesigner1: TMMDesigner;
    audiofile: TMMAudioFile;
    pitch: TMMPitch;
    waveout: TMMWaveOut;
    MMBitmapButton2: TMMBitmapButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure addplaylistClick(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure playClick(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure waveoutStop(Sender: TObject);
    procedure HiTimerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    Procedure saves_database;
    { Public declarations }
  end;

var
  timesignal: Ttimesignal;

implementation

uses Form_playlist, form_mainform, Form_songLibrary;

{$R *.dfm}

procedure Ttimesignal.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  FormStyle:=fsnormal;
  Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure Ttimesignal.addplaylistClick(Sender: TObject);
var i:integer;
begin
  if playlistgrid.Cells[1,playlistgrid.Row]<>'' then
  begin
    for i:=1 to 2 do
    begin
      playlistgrid.Cells[i,playlistgrid.Row]:='';
    end;
    saves_database;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Cannot remove empty file!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Tidak dapat menghapus file kosong!',mtconfirmation,[mbok],0);
  end;
end;

procedure Ttimesignal.MMBitmapButton1Click(Sender: TObject);
var i,j:integer;
begin
  if languages=0 then pesan:='Clear all time signal playlist?';
  if languages=1 then pesan:='Hapus semua daftar penanda waktu?';

  if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
  begin
    playlistgrid.RowCount:=25;
    for j:=1 to playlistgrid.rowCount-1 do
    begin
      playlistgrid.Cells[1,j]:='';
      playlistgrid.Cells[2,j]:='';
    end;
    playlistgrid.RowCount:=25;
    playlistgrid.Cells[0,1]:='01 AM';
    playlistgrid.Cells[0,2]:='02 AM';
    playlistgrid.Cells[0,3]:='03 AM';
    playlistgrid.Cells[0,4]:='04 AM';
    playlistgrid.Cells[0,5]:='05 AM';
    playlistgrid.Cells[0,6]:='06 AM';
    playlistgrid.Cells[0,7]:='07 AM';
    playlistgrid.Cells[0,8]:='08 AM';
    playlistgrid.Cells[0,9]:='09 AM';
    playlistgrid.Cells[0,10]:='10 AM';
    playlistgrid.Cells[0,11]:='11 AM';
    playlistgrid.Cells[0,12]:='12 PM';
    playlistgrid.Cells[0,13]:='01 PM';
    playlistgrid.Cells[0,14]:='02 PM';
    playlistgrid.Cells[0,15]:='03 PM';
    playlistgrid.Cells[0,16]:='04 PM';
    playlistgrid.Cells[0,17]:='05 PM';
    playlistgrid.Cells[0,18]:='06 PM';
    playlistgrid.Cells[0,19]:='07 PM';
    playlistgrid.Cells[0,20]:='08 PM';
    playlistgrid.Cells[0,21]:='09 PM';
    playlistgrid.Cells[0,22]:='10 PM';
    playlistgrid.Cells[0,23]:='11 PM';
    playlistgrid.Cells[0,24]:='12 AM';
    saves_database;
  end;
end;

Procedure Ttimesignal.saves_database;
var i:Integer;
begin
  mainform.Db_Timesignal.EmptyTable;
  for i:=1 to playlistgrid.RowCount do
  begin
    mainform.Db_Timesignal.Append;
    if playlistgrid.Cells[0,i]<>''  then mainform.db_timesignal.FieldByName('Time').AsString    :=playlistgrid.Cells[0,i];
    if playlistgrid.Cells[1,i]<>''  then mainform.db_timesignal.FieldByName('Name').AsString    :=playlistgrid.Cells[1,i];
    if playlistgrid.Cells[2,i]<>''  then mainform.db_timesignal.FieldByName('realname').AsString:=playlistgrid.Cells[2,i];
    if playlistgrid.Cells[3,i]<>''  then mainform.db_timesignal.FieldByName('status').AsString  :=playlistgrid.Cells[3,i];
    mainform.db_timesignal.Post;
  end;
end;

procedure Ttimesignal.MMBitmapButton3Click(Sender: TObject);
begin
  if playlistgrid.Row>0 then
  begin
    if musiclibrary.FormStyle<>fsmdichild then
    begin
      mainform.MusicLibrary1.Click;
    end;
    musiclibrary.BringToFront;

    if musiclibrary.searchgrid.Visible=true then
    begin
      if musiclibrary.searchgrid.Cells[0,musiclibrary.searchgrid.row]<>'' then
      begin
        playlistgrid.Cells[1,playlistgrid.Row]:=musiclibrary.searchgrid.Cells[0,musiclibrary.searchgrid.row];
        playlistgrid.Cells[2,playlistgrid.Row]:=musiclibrary.searchgrid.Cells[5,musiclibrary.searchgrid.row];
      end;
    end else
    begin
      if musiclibrary.playlistgrid.Cells[0,musiclibrary.playlistgrid.row]<>'' then
      begin
        playlistgrid.Cells[1,playlistgrid.Row]:=musiclibrary.playlistgrid.Cells[0,musiclibrary.playlistgrid.row];
        playlistgrid.Cells[2,playlistgrid.Row]:=musiclibrary.playlistgrid.Cells[5,musiclibrary.playlistgrid.row];
      end;

    end;
    saves_database;
  end;
end;

procedure Ttimesignal.playClick(Sender: TObject);
begin
  if fileexists(playlistgrid.Cells[2,playlistgrid.row]) then
  begin
    if mainform.Label_onair.Caption='ON AIR' then mainform.btn_pause.OnClick(self);
    if IsMpegFile(playlistgrid.Cells[2,playlistgrid.row]) then
    begin
      audiofile.FileName :=playlistgrid.Cells[2,playlistgrid.row];
      audiofile.FadeOutDuration:=2000;
      audiofile.FadeInDuration:=500;
      WaveOut.Input := audiofile;
      waveout.Stop;
      waveout.Started;
    end;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
  end;
end;

procedure Ttimesignal.MMBitmapButton2Click(Sender: TObject);
begin
  audiofile.FadeOut(audiofile.FadeOutDuration);
  //if mainform.Label_onair.Caption='PAUSE' then mainform.btn_pause.OnClick(self);
end;

procedure Ttimesignal.waveoutStop(Sender: TObject);
begin
  WaveOut.Close;
  if mainform.Label_onair.Caption='PAUSE' then mainform.btn_pause.OnClick(self);
end;

procedure Ttimesignal.HiTimerTimer(Sender: TObject);
begin
  //if waveout.
end;

end.
